/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.plugin.InExporter;
import org.jivesoftware.openfire.plugin.UserSchemaValidator;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterItemProvider;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class OpenfireExporter
implements InExporter {
    private static final Logger Log = LoggerFactory.getLogger(OpenfireExporter.class);
    private final String serverName;
    private final UserManager userManager;
    private final RosterItemProvider rosterItemProvider;

    public OpenfireExporter() {
        this.serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        this.userManager = UserManager.getInstance();
        this.rosterItemProvider = RosterManager.getRosterItemProvider();
    }

    public OpenfireExporter(String serverName, UserManager userManager, RosterItemProvider rosterItemProvider) {
        this.serverName = serverName;
        this.userManager = userManager;
        this.rosterItemProvider = rosterItemProvider;
    }

    @Override
    public Document exportUsers() {
        Log.debug("exportUsers");
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("Openfire");
        Collection users = this.userManager.getUsers();
        for (User user : users) {
            Element userElement = root.addElement("User");
            String userName = user.getUsername();
            userElement.addElement("Username").addText(userName);
            try {
                String pw = AuthFactory.getPassword((String)user.getUsername());
                userElement.addElement("Password").addText(pw);
            }
            catch (UserNotFoundException e) {
                Log.info("User " + userName + " not found, setting their password to their username");
                userElement.addElement("Password").addText(userName);
            }
            catch (UnsupportedOperationException e) {
                Log.info("Unable to retrieve " + userName + " password, setting their password to their username");
                userElement.addElement("Password").addText(userName);
            }
            userElement.addElement("Email").addText(user.getEmail() == null ? "" : user.getEmail());
            String name = user.getName();
            userElement.addElement("Name").addText(name == null ? "" : name);
            userElement.addElement("CreationDate").addText(String.valueOf(user.getCreationDate().getTime()));
            userElement.addElement("ModifiedDate").addText(String.valueOf(user.getModificationDate().getTime()));
            Element rosterElement = userElement.addElement("Roster");
            Collection roster = user.getRoster().getRosterItems();
            for (RosterItem ri : roster) {
                Element itemElement = rosterElement.addElement("Item");
                itemElement.addAttribute("jid", ri.getJid().toBareJID());
                itemElement.addAttribute("askstatus", String.valueOf(ri.getAskStatus().getValue()));
                itemElement.addAttribute("recvstatus", String.valueOf(ri.getRecvStatus().getValue()));
                itemElement.addAttribute("substatus", String.valueOf(ri.getSubStatus().getValue()));
                itemElement.addAttribute("name", ri.getNickname());
                List groups = ri.getGroups();
                for (String group : groups) {
                    if (group == null || group.trim().length() <= 0) continue;
                    itemElement.addElement("Group").addText(group);
                }
            }
        }
        return document;
    }

    @Override
    public boolean validate(InputStream file) {
        Log.debug("validate");
        org.w3c.dom.Document doc = new UserSchemaValidator(file, "wildfire-user-schema.xsd.xml").validateAndParse();
        return doc != null;
    }

    @Override
    public List<String> importUsers(InputStream inputStream, String previousDomain, boolean isUserProviderReadOnly) {
        Log.debug("importUsers");
        DOMReader xmlReader = new DOMReader();
        Document doc = xmlReader.read(new UserSchemaValidator(inputStream, new String[0]).validateAndParse());
        return this.importUsers(doc, previousDomain, isUserProviderReadOnly);
    }

    private List<String> importUsers(Document document, String previousDomain, boolean isUserProviderReadOnly) {
        Log.debug("importUsers");
        ArrayList<String> invalidUsers = new ArrayList<String>();
        Element users = document.getRootElement();
        Iterator usersIter = users.elementIterator("User");
        while (usersIter.hasNext()) {
            Element user = (Element)usersIter.next();
            String userName = null;
            String password = null;
            String email = null;
            String name = null;
            ArrayList<RosterItem> rosterItems = new ArrayList<RosterItem>();
            Iterator userElements = user.elementIterator();
            while (userElements.hasNext()) {
                Element userElement = (Element)userElements.next();
                String nameElement = userElement.getName();
                if ("Username".equals(nameElement)) {
                    userName = userElement.getText();
                    continue;
                }
                if ("Password".equals(nameElement)) {
                    password = userElement.getText();
                    continue;
                }
                if ("Name".equals(nameElement)) {
                    name = userElement.getText();
                    continue;
                }
                if ("Email".equals(nameElement)) {
                    email = userElement.getText();
                    continue;
                }
                if (!"Roster".equals(nameElement)) continue;
                Iterator rosterIter = userElement.elementIterator("Item");
                while (rosterIter.hasNext()) {
                    Element rosterElement = (Element)rosterIter.next();
                    String jid = rosterElement.attributeValue("jid");
                    String askstatus = rosterElement.attributeValue("askstatus");
                    String recvstatus = rosterElement.attributeValue("recvstatus");
                    String substatus = rosterElement.attributeValue("substatus");
                    String nickname = rosterElement.attributeValue("name");
                    ArrayList<String> groups = new ArrayList<String>();
                    Iterator groupIter = rosterElement.elementIterator("Group");
                    while (groupIter.hasNext()) {
                        Element group = (Element)groupIter.next();
                        String groupName = group.getText();
                        if (groupName == null || groupName.trim().length() <= 0) continue;
                        groups.add(groupName);
                    }
                    if (previousDomain != null) {
                        jid = jid.replace(previousDomain, this.serverName);
                    }
                    rosterItems.add(new RosterItem(new JID(jid), RosterItem.SubType.getTypeFromInt((int)Integer.parseInt(substatus)), RosterItem.AskType.getTypeFromInt((int)Integer.parseInt(askstatus)), RosterItem.RecvType.getTypeFromInt((int)Integer.parseInt(recvstatus)), nickname, groups));
                }
            }
            if (userName == null) continue;
            try {
                userName = Stringprep.nodeprep(userName);
                if (!isUserProviderReadOnly && password != null) {
                    this.userManager.createUser(userName, password, name, email);
                }
                this.userManager.getUser(userName);
                for (RosterItem ri : rosterItems) {
                    this.rosterItemProvider.createItem(userName, ri);
                }
            }
            catch (StringprepException se) {
                Log.info("Invalid username " + userName);
                invalidUsers.add(userName);
            }
            catch (UserAlreadyExistsException e) {
                Log.info("User already exists " + userName);
                invalidUsers.add(userName);
            }
            catch (UserNotFoundException e) {
                Log.info("User not found " + userName);
                invalidUsers.add(userName);
            }
        }
        return invalidUsers;
    }
}

