/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UserSchemaValidator {
    private static final Logger Log = LoggerFactory.getLogger(UserSchemaValidator.class);
    private static final CharSequence STRICT_DECLARATION_MSG = "The matching wildcard is strict, but no declaration can be found for element";
    private final InputStream source;
    private final Source[] schemaSources;

    UserSchemaValidator(InputStream source, String ... schemaFile) {
        this.source = source;
        ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
        for (String schema : schemaFile) {
            try {
                URL schemaURL = this.getClass().getClassLoader().getResource(schema);
                if (schemaURL != null) {
                    sourceList.add(new StreamSource(schemaURL.openStream()));
                    continue;
                }
                Log.warn("Cannot find schema definition " + schema);
            }
            catch (IOException e) {
                Log.warn("Cannot open schema definition " + schema + " : " + e.getMessage());
                Log.debug("", (Throwable)e);
            }
        }
        this.schemaSources = new Source[sourceList.size()];
        sourceList.toArray(this.schemaSources);
    }

    Document validateAndParse() {
        ValidatorErrorHandler handler = new ValidatorErrorHandler();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setXIncludeAware(true);
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/xinclude/fixup-language", false);
            if (this.schemaSources.length > 0) {
                Log.info("Checking Schema's");
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaFactory.setErrorHandler(handler);
                Schema schema = schemaFactory.newSchema(this.schemaSources);
                documentBuilderFactory.setSchema(schema);
                Log.info("Start validating document");
            } else {
                Log.info("Loading document");
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            handler.reset();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    Log.info(String.format("resolved Entity:%s %s", publicId != null ? publicId : "", systemId));
                    return null;
                }
            });
            documentBuilder.setErrorHandler(handler);
            Document result = documentBuilder.parse(this.source);
            if (result != null && handler.isValid()) {
                return result;
            }
            Log.warn(String.format("document is invalid. %1$d errors found.", handler.getNrOfErrors()));
            return null;
        }
        catch (Exception e) {
            Log.warn(String.format("document validation failed. %1$d errors found.", handler.getNrOfErrors()));
            Log.debug("", (Throwable)e);
            return null;
        }
    }

    private class ValidatorErrorHandler
    implements ErrorHandler {
        private int nrOfErrors = 0;

        private ValidatorErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            if (e.getMessage().contains(STRICT_DECLARATION_MSG)) {
                Log.warn("This error indicates there is no XML Schema to validate the refered element: " + e.getLocalizedMessage());
            } else {
                Log.warn("ERROR:" + e.getLocalizedMessage());
                ++this.nrOfErrors;
            }
        }

        @Override
        public void fatalError(SAXParseException e) {
            Log.error("Fatal:" + e.getLocalizedMessage());
            ++this.nrOfErrors;
        }

        @Override
        public void warning(SAXParseException e) {
            Log.error("Warning:" + e.getLocalizedMessage());
        }

        public void reset() {
            this.nrOfErrors = 0;
        }

        public boolean isValid() {
            return this.nrOfErrors == 0;
        }

        public int getNrOfErrors() {
            return this.nrOfErrors;
        }
    }
}

