/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DOMReader;
import org.jivesoftware.openfire.OfflineMessage;
import org.jivesoftware.openfire.OfflineMessageStore;
import org.jivesoftware.openfire.PrivateStorage;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.plugin.InExporter;
import org.jivesoftware.openfire.plugin.UserSchemaValidator;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterItemProvider;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.vcard.VCardManager;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class Xep227Exporter
implements InExporter {
    private static final String V_CARD_NAME = "vCard";
    private static final String ASK_SUBSCRIBE_ENUM = "subscribe";
    private static final String STAMP_NAME = "stamp";
    private static final String DELAY_ELEMENT_NAME = "delay";
    private static final String FROM_NAME = "from";
    private static final String MESSAGE_ELEMENT_NAME = "message";
    private static final String OFFLINE_MESSAGES_ELEMENT_NAME = "offline-messages";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String SUBSCRIPTION_NAME = "subscription";
    private static final String ASK_NAME = "ask";
    private static final String ITEM_ELEMENT_NAME = "item";
    private static final String QUERY_ELEMENT_NAME = "query";
    private static final String PASSWORD_NAME = "password";
    private static final String NAME_NAME = "name";
    private static final String USER_ELEMENT_NAME = "user";
    private static final String JID_NAME = "jid";
    private static final String HOST_ELEMENT_NAME = "host";
    private static final String SERVER_DATA_ELEMENT_NAME = "server-data";
    private static final String JABBER_CLIENT_NS = "jabber:client";
    private static final String VCARD_TEMP_NS = "vcard-temp";
    private static final String JABBER_IQ_ROSTER_NS = "jabber:iq:roster";
    private static final String URN_XMPP_PIE_0_NS = "urn:xmpp:pie:0";
    private static final Namespace JABBER_MSG_NS = new Namespace("", "jabber:client");
    private static final Logger Log = LoggerFactory.getLogger(Xep227Exporter.class);
    private final String serverName;
    private final OfflineMessageStore offlineMessagesStore;
    private final VCardManager vCardManager;
    private final UserManager userManager;
    private final RosterItemProvider rosterItemProvider;
    private final DateFormat dateformater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

    public Xep227Exporter() {
        this.offlineMessagesStore = XMPPServer.getInstance().getOfflineMessageStore();
        this.serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        this.vCardManager = VCardManager.getInstance();
        this.userManager = UserManager.getInstance();
        this.rosterItemProvider = RosterManager.getRosterItemProvider();
    }

    public Xep227Exporter(String serverName, OfflineMessageStore offlineMessagesStore, VCardManager vCardManager, PrivateStorage privateStorage, UserManager userManager, RosterItemProvider rosterItemProvider) {
        this.serverName = serverName;
        this.offlineMessagesStore = offlineMessagesStore;
        this.vCardManager = vCardManager;
        this.userManager = userManager;
        this.rosterItemProvider = rosterItemProvider;
    }

    @Override
    public Document exportUsers() {
        Log.debug("exportUsers");
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(SERVER_DATA_ELEMENT_NAME, URN_XMPP_PIE_0_NS);
        Element host = root.addElement(HOST_ELEMENT_NAME);
        host.addAttribute(JID_NAME, this.serverName);
        Collection users = this.userManager.getUsers();
        for (User user : users) {
            String userName = user.getUsername();
            Element userElement = host.addElement(USER_ELEMENT_NAME);
            this.exportUser(userElement, user);
            this.exportOfflineMessages(this.serverName, userElement, userName);
            this.exportRoster(userElement, user);
            this.exportVCard(userElement, userName);
            this.exportPrivateStorage(userName, userElement);
        }
        return document;
    }

    private void exportUser(Element userElement, User user) {
        String userName = user.getUsername();
        userElement.addAttribute(NAME_NAME, userName);
        try {
            String pw = AuthFactory.getPassword((String)userName);
            userElement.addAttribute(PASSWORD_NAME, pw);
        }
        catch (UserNotFoundException e) {
            Log.info("User " + userName + " not found, setting their password to their username");
            userElement.addAttribute(PASSWORD_NAME, userName);
        }
        catch (UnsupportedOperationException e) {
            Log.info("Unable to retrieve " + userName + " password, setting their password to their username");
            userElement.addAttribute(PASSWORD_NAME, userName);
        }
    }

    private void exportRoster(Element userElement, User user) {
        Element rosterElement = userElement.addElement(QUERY_ELEMENT_NAME, JABBER_IQ_ROSTER_NS);
        Collection roster = user.getRoster().getRosterItems();
        for (RosterItem ri : roster) {
            Element itemElement = rosterElement.addElement(ITEM_ELEMENT_NAME);
            itemElement.addAttribute(JID_NAME, ri.getJid().toBareJID());
            itemElement.addAttribute(NAME_NAME, ri.getNickname());
            itemElement.addAttribute(SUBSCRIPTION_NAME, ri.getSubStatus().getName());
            if (ri.getAskStatus() == RosterItem.AskType.SUBSCRIBE) {
                itemElement.addAttribute(ASK_NAME, ASK_SUBSCRIBE_ENUM);
            }
            Element groupElement = itemElement.addElement(GROUP_ELEMENT_NAME);
            List groups = ri.getGroups();
            for (String group : groups) {
                groupElement.addText(group);
            }
        }
    }

    private void exportOfflineMessages(String hostname, Element userElement, String userName) {
        Collection offlineMessages = this.offlineMessagesStore.getMessages(userName, false);
        if (!offlineMessages.isEmpty()) {
            Element offlineElement = userElement.addElement(OFFLINE_MESSAGES_ELEMENT_NAME);
            for (OfflineMessage offMessage : offlineMessages) {
                Element messageElement = offlineElement.addElement(new QName(MESSAGE_ELEMENT_NAME, JABBER_MSG_NS));
                for (Object att : offMessage.getElement().attributes()) {
                    Attribute attribute = (Attribute)att;
                    messageElement.addAttribute(attribute.getQName(), attribute.getValue());
                }
                Iterator iterator = offMessage.getElement().elementIterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    messageElement.add(element.createCopy(new QName(element.getName(), element.getNamespace() == Namespace.NO_NAMESPACE ? JABBER_MSG_NS : element.getNamespace())));
                }
                Element delayElement = messageElement.addElement(DELAY_ELEMENT_NAME, "urn:xmpp:delay");
                delayElement.addAttribute(FROM_NAME, hostname);
                delayElement.addAttribute(STAMP_NAME, XMPPDateTimeFormat.format((Date)offMessage.getCreationDate()));
                delayElement.addText("Offline Storage");
            }
        }
    }

    private void exportVCard(Element userElement, String userName) {
        Element vCard = this.vCardManager.getVCard(userName);
        if (vCard != null) {
            Element vCardElement = userElement.addElement(V_CARD_NAME, VCARD_TEMP_NS);
            Iterator iterator = vCard.elementIterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                vCardElement.add(element.createCopy());
            }
        }
    }

    private void exportPrivateStorage(String userName, Element userElement) {
    }

    @Override
    public boolean validate(InputStream file) {
        Log.debug("validate");
        org.w3c.dom.Document doc = new UserSchemaValidator(file, "pie.xsd", "jabber-iq-roster.xsd", "jabber-iq-private.xsd", "xml.xsd", "stanzaerror.xsd", "jabber-client.xsd").validateAndParse();
        return doc != null;
    }

    @Override
    public List<String> importUsers(InputStream inputStream, String previousDomain, boolean isUserProviderReadOnly) {
        Log.debug("importUsers");
        DOMReader xmlReader = new DOMReader();
        Document doc = xmlReader.read(new UserSchemaValidator(inputStream, new String[0]).validateAndParse());
        return this.importUsers(doc, previousDomain, isUserProviderReadOnly);
    }

    private List<String> importUsers(Document document, String previousDomain, boolean isUserProviderReadOnly) {
        ArrayList<String> invalidUsers = new ArrayList<String>();
        Element hosts = document.getRootElement();
        Iterator hostsIter = hosts.elementIterator(HOST_ELEMENT_NAME);
        while (hostsIter.hasNext()) {
            Element host = (Element)hostsIter.next();
            Iterator usersIter = host.elementIterator(USER_ELEMENT_NAME);
            while (usersIter.hasNext()) {
                Element user = (Element)usersIter.next();
                this.importUser(user, previousDomain, isUserProviderReadOnly, invalidUsers);
            }
        }
        return invalidUsers;
    }

    private void importUser(Element user, String previousDomain, boolean isUserProviderReadOnly, List<String> invalidUsers) {
        Log.debug("importUser");
        ArrayList<RosterItem> rosterItems = new ArrayList<RosterItem>();
        ArrayList<OfflineMessage> offlineMessages = new ArrayList<OfflineMessage>();
        Element vCardElement = null;
        String userName = user.attributeValue(NAME_NAME);
        String password = user.attributeValue(PASSWORD_NAME);
        Iterator userElements = user.elementIterator();
        while (userElements.hasNext()) {
            Element userElement = (Element)userElements.next();
            String nameElement = userElement.getName();
            if (OFFLINE_MESSAGES_ELEMENT_NAME.equals(nameElement)) {
                this.importOffLineMessages(userElement, offlineMessages);
                continue;
            }
            if (QUERY_ELEMENT_NAME.equals(nameElement) && JABBER_IQ_ROSTER_NS.equals(userElement.getNamespaceURI())) {
                this.importUserRoster(userElement, rosterItems, previousDomain);
                continue;
            }
            if (!V_CARD_NAME.equals(nameElement) || !VCARD_TEMP_NS.equals(userElement.getNamespaceURI())) continue;
            vCardElement = userElement;
        }
        if (userName != null) {
            try {
                userName = Stringprep.nodeprep((String)userName);
                if (!isUserProviderReadOnly && password != null) {
                    this.userManager.createUser(userName, password, userName, null);
                }
                if (!isUserProviderReadOnly && vCardElement != null) {
                    try {
                        this.vCardManager.setVCard(userName, vCardElement);
                    }
                    catch (Exception e) {
                        Log.warn("Error updating VCard:" + userName + ":" + e.getMessage());
                        Log.debug("", (Throwable)e);
                    }
                }
                this.userManager.getUser(userName);
                for (RosterItem ri : rosterItems) {
                    this.rosterItemProvider.createItem(userName, ri);
                }
                for (OfflineMessage offlineMessage : offlineMessages) {
                    this.offlineMessagesStore.addMessage((Message)offlineMessage);
                }
            }
            catch (StringprepException se) {
                Log.info("Invalid username " + userName);
                invalidUsers.add(userName);
            }
            catch (UserAlreadyExistsException e) {
                Log.info("User already exists " + userName);
                invalidUsers.add(userName);
            }
            catch (UserNotFoundException e) {
                Log.info("User not found " + userName);
                invalidUsers.add(userName);
            }
            catch (Exception e) {
                Log.warn("Error updating User:" + userName + ":" + e.getLocalizedMessage());
                invalidUsers.add(userName);
            }
        }
    }

    private void importUserRoster(Element userElement, List<RosterItem> rosterItems, String previousDomain) {
        Log.debug("importUserRoster");
        Iterator rosterIter = userElement.elementIterator(ITEM_ELEMENT_NAME);
        while (rosterIter.hasNext()) {
            Element rosterElement = (Element)rosterIter.next();
            String jid = rosterElement.attributeValue(JID_NAME);
            String nickname = rosterElement.attributeValue(NAME_NAME);
            String substatus = rosterElement.attributeValue(SUBSCRIPTION_NAME);
            String askstatus = rosterElement.attributeValue(ASK_NAME);
            ArrayList<String> groups = new ArrayList<String>();
            Iterator groupIter = rosterElement.elementIterator(GROUP_ELEMENT_NAME);
            while (groupIter.hasNext()) {
                Element group = (Element)groupIter.next();
                String groupName = group.getText();
                if (groupName == null || groupName.trim().length() <= 0) continue;
                groups.add(groupName);
            }
            if (previousDomain != null && jid != null) {
                jid = jid.replace(previousDomain, this.serverName);
            }
            try {
                rosterItems.add(new RosterItem(new JID(jid), substatus != null ? RosterItem.SubType.valueOf((String)substatus.toUpperCase()) : RosterItem.SubType.BOTH, ASK_SUBSCRIBE_ENUM.equals(askstatus) ? RosterItem.AskType.SUBSCRIBE : RosterItem.AskType.NONE, RosterItem.RecvType.NONE, nickname, groups));
            }
            catch (Exception e) {
                Log.warn("Adding User Roster failed:" + e.getLocalizedMessage());
                Log.debug("", (Throwable)e);
            }
        }
    }

    private void importOffLineMessages(Element userElement, List<OfflineMessage> offlineMessages) {
        Log.debug("importOffLineMessages");
        Iterator messageIter = userElement.elementIterator(MESSAGE_ELEMENT_NAME);
        while (messageIter.hasNext()) {
            Element msgElement = (Element)messageIter.next();
            String creationDateStr = null;
            if (msgElement.element(DELAY_ELEMENT_NAME) != null) {
                creationDateStr = msgElement.element(DELAY_ELEMENT_NAME).attributeValue(STAMP_NAME);
            }
            Date creationDate = null;
            try {
                if (creationDateStr != null) {
                    creationDate = this.dateformater.parse(creationDateStr);
                }
            }
            catch (ParseException e) {
                Log.warn("Date not parsable:" + e.getLocalizedMessage());
            }
            offlineMessages.add(new OfflineMessage(creationDate, msgElement));
        }
    }
}

