/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.entity.RosterEntities;
import org.jivesoftware.openfire.entity.RosterItemEntity;
import org.jivesoftware.openfire.entity.UserEntities;
import org.jivesoftware.openfire.entity.UserEntity;
import org.jivesoftware.openfire.entity.UserGroupsEntity;
import org.jivesoftware.openfire.entity.UserProperty;
import org.jivesoftware.openfire.exceptions.ServiceException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.plugin.PropertyDAO;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.utils.UserUtils;
import org.xmpp.packet.JID;

public class UserServicePluginNG {
    public static final UserServicePluginNG INSTANCE = new UserServicePluginNG();
    private UserManager userManager;
    private RosterManager rosterManager;
    private XMPPServer server = XMPPServer.getInstance();

    public static UserServicePluginNG getInstance() {
        return INSTANCE;
    }

    private UserServicePluginNG() {
        this.userManager = this.server.getUserManager();
        this.rosterManager = this.server.getRosterManager();
    }

    public void createUser(UserEntity userEntity) throws ServiceException {
        if (userEntity != null && !userEntity.getUsername().isEmpty()) {
            if (userEntity.getPassword() == null) {
                throw new ServiceException("Could not create new user, because password is null", userEntity.getUsername(), "PasswordIsNull", Response.Status.BAD_REQUEST);
            }
            try {
                this.userManager.createUser(userEntity.getUsername(), userEntity.getPassword(), userEntity.getName(), userEntity.getEmail());
            }
            catch (UserAlreadyExistsException e) {
                throw new ServiceException("Could not create new user", userEntity.getUsername(), "UserAlreadyExistsException", Response.Status.BAD_REQUEST);
            }
            this.addProperties(userEntity);
        }
    }

    public void updateUser(String username, UserEntity userEntity) throws ServiceException {
        if (userEntity != null && !username.isEmpty()) {
            User user = this.getAndCheckUser(username);
            if (userEntity.getPassword() != null) {
                user.setPassword(userEntity.getPassword());
            }
            if (userEntity.getName() != null) {
                user.setName(userEntity.getName());
            }
            if (userEntity.getEmail() != null) {
                user.setEmail(userEntity.getEmail());
            }
            this.addProperties(userEntity);
        }
    }

    public void deleteUser(String username) throws ServiceException {
        User user = this.getAndCheckUser(username);
        this.userManager.deleteUser(user);
        this.rosterManager.deleteRoster(this.server.createJID(username, null));
    }

    public UserEntities getUserEntities(String userSearch) {
        UserEntities userEntities = new UserEntities();
        userEntities.setUsers(UserUtils.convertUsersToUserEntities(this.userManager.getUsers(), userSearch));
        return userEntities;
    }

    public UserEntity getUserEntity(String username) throws ServiceException {
        return UserUtils.convertUserToUserEntity(this.getAndCheckUser(username));
    }

    public void enableUser(String username) throws ServiceException {
        this.getAndCheckUser(username);
        LockOutManager.getInstance().enableAccount(username);
    }

    public void disableUser(String username) throws ServiceException {
        this.getAndCheckUser(username);
        LockOutManager.getInstance().disableAccount(username, null, null);
    }

    public RosterEntities getRosterEntities(String username) throws ServiceException {
        Roster roster = this.getUserRoster(username);
        ArrayList<RosterItemEntity> rosterEntities = new ArrayList<RosterItemEntity>();
        for (RosterItem rosterItem : roster.getRosterItems()) {
            RosterItemEntity rosterItemEntity = new RosterItemEntity(rosterItem.getJid().toBareJID(), rosterItem.getNickname(), rosterItem.getSubStatus().getValue());
            rosterItemEntity.setGroups(rosterItem.getGroups());
            rosterEntities.add(rosterItemEntity);
        }
        return new RosterEntities(rosterEntities);
    }

    public void addRosterItem(String username, RosterItemEntity rosterItemEntity) throws ServiceException, UserAlreadyExistsException, SharedGroupException, UserNotFoundException {
        Roster roster = this.getUserRoster(username);
        if (rosterItemEntity.getJid() == null) {
            throw new ServiceException("JID is null", "JID", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        JID jid = new JID(rosterItemEntity.getJid());
        try {
            roster.getRosterItem(jid);
            throw new UserAlreadyExistsException(jid.toBareJID());
        }
        catch (UserNotFoundException userNotFoundException) {
            if (roster != null) {
                RosterItem rosterItem = roster.createRosterItem(jid, rosterItemEntity.getNickname(), rosterItemEntity.getGroups(), false, true);
                UserUtils.checkSubType(rosterItemEntity.getSubscriptionType());
                rosterItem.setSubStatus(RosterItem.SubType.getTypeFromInt((int)rosterItemEntity.getSubscriptionType()));
                roster.updateRosterItem(rosterItem);
            }
            return;
        }
    }

    public void updateRosterItem(String username, String rosterJid, RosterItemEntity rosterItemEntity) throws ServiceException, UserNotFoundException, UserAlreadyExistsException, SharedGroupException {
        this.getAndCheckUser(username);
        Roster roster = this.getUserRoster(username);
        JID jid = new JID(rosterJid);
        RosterItem rosterItem = roster.getRosterItem(jid);
        if (rosterItemEntity.getNickname() != null) {
            rosterItem.setNickname(rosterItemEntity.getNickname());
        }
        if (rosterItemEntity.getGroups() != null) {
            rosterItem.setGroups(rosterItemEntity.getGroups());
        }
        UserUtils.checkSubType(rosterItemEntity.getSubscriptionType());
        rosterItem.setSubStatus(RosterItem.SubType.getTypeFromInt((int)rosterItemEntity.getSubscriptionType()));
        roster.updateRosterItem(rosterItem);
    }

    public void deleteRosterItem(String username, String rosterJid) throws SharedGroupException, ServiceException {
        this.getAndCheckUser(username);
        Roster roster = this.getUserRoster(username);
        JID jid = new JID(rosterJid);
        if (roster.deleteRosterItem(jid, true) == null) {
            throw new ServiceException("Roster Item could not deleted", jid.toBareJID(), "RosterItemNotFound", Response.Status.NOT_FOUND);
        }
    }

    public List<String> getUserGroups(String username) throws ServiceException {
        User user = this.getAndCheckUser(username);
        Collection groups = GroupManager.getInstance().getGroups(user);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public void addUserToGroups(String username, UserGroupsEntity userGroupsEntity) throws ServiceException {
        if (userGroupsEntity != null) {
            ArrayList<Group> groups = new ArrayList<Group>();
            for (String groupName : userGroupsEntity.getGroupNames()) {
                Group group = null;
                try {
                    group = GroupManager.getInstance().getGroup(groupName);
                }
                catch (GroupNotFoundException e) {
                    group = this.createGroup(groupName);
                }
                groups.add(group);
            }
            for (Group group : groups) {
                group.getMembers().add(this.server.createJID(username, null));
            }
        }
    }

    public void deleteUserFromGroups(String username, UserGroupsEntity userGroupsEntity) throws ServiceException {
        if (userGroupsEntity != null) {
            for (String groupName : userGroupsEntity.getGroupNames()) {
                Group group = null;
                try {
                    group = GroupManager.getInstance().getGroup(groupName);
                }
                catch (GroupNotFoundException e) {
                    throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
                }
                group.getMembers().remove(this.server.createJID(username, null));
            }
        }
    }

    public UserEntities getUserEntitiesByProperty(String propertyKey, String propertyValue) throws ServiceException {
        List<String> usernames = PropertyDAO.getUsernameByProperty(propertyKey, propertyValue);
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        UserEntities userEntities = new UserEntities();
        for (String username : usernames) {
            users.add(this.getUserEntity(username));
        }
        userEntities.setUsers(users);
        return userEntities;
    }

    private void addProperties(UserEntity userEntity) throws ServiceException {
        User user = this.getAndCheckUser(userEntity.getUsername());
        user.getProperties().clear();
        if (userEntity.getProperties() != null) {
            for (UserProperty property : userEntity.getProperties()) {
                user.getProperties().put(property.getKey(), property.getValue());
            }
        }
    }

    private Group createGroup(String groupName) throws ServiceException {
        Group group = null;
        try {
            group = GroupManager.getInstance().createGroup(groupName);
            group.getProperties().put((Object)"sharedRoster.showInRoster", (Object)"onlyGroup");
            group.getProperties().put((Object)"sharedRoster.displayName", (Object)groupName);
            group.getProperties().put((Object)"sharedRoster.groupList", (Object)"");
        }
        catch (GroupAlreadyExistsException e) {
            throw new ServiceException("Could not create group", groupName, "GroupAlreadyExistsException", Response.Status.BAD_REQUEST, e);
        }
        return group;
    }

    private User getAndCheckUser(String username) throws ServiceException {
        JID targetJID = this.server.createJID(username, null);
        if (targetJID.getNode() == null) {
            throw new ServiceException("Could not get user", username, "UserNotFoundException", Response.Status.NOT_FOUND);
        }
        try {
            return this.userManager.getUser(targetJID.getNode());
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Could not get user", username, "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }

    private Roster getUserRoster(String username) throws ServiceException {
        try {
            return this.rosterManager.getRoster(username);
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Could not get user roster", username, "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }
}

