/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.entity.UserEntity;
import org.jivesoftware.openfire.entity.UserProperty;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;

public class UserUtils {
    private UserUtils() {
        throw new AssertionError();
    }

    public static List<UserEntity> convertUsersToUserEntities(Collection<User> users, String userSearch) {
        ArrayList<UserEntity> result = new ArrayList<UserEntity>();
        for (User user : users) {
            if (userSearch != null && !user.getUsername().contains(userSearch)) continue;
            result.add(UserUtils.convertUserToUserEntity(user));
        }
        return result;
    }

    public static UserEntity convertUserToUserEntity(User user) {
        UserEntity userEntity = new UserEntity(user.getUsername(), user.getName(), user.getEmail());
        ArrayList<UserProperty> userProperties = new ArrayList<UserProperty>();
        for (Map.Entry property : user.getProperties().entrySet()) {
            userProperties.add(new UserProperty((String)property.getKey(), (String)property.getValue()));
        }
        userEntity.setProperties(userProperties);
        return userEntity;
    }

    public static void checkSubType(int subType) throws UserAlreadyExistsException {
        if (subType < -1 || subType > 3) {
            throw new UserAlreadyExistsException();
        }
    }
}

