/*
 * Decompiled with CFR 0.152.
 */
package com.reucon.openfire.plugins.userstatus;

import com.reucon.openfire.plugins.userstatus.PersistenceManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpBB3PersistenceManager
implements PersistenceManager {
    private static final Logger Log = LoggerFactory.getLogger(PhpBB3PersistenceManager.class);
    private static final String UPDATE_USER_STATUS = "UPDATE users SET user_jabber_online = 1 WHERE user_jid = ?";
    private static final String SET_PRESENCE = "UPDATE users SET user_jabber_presence = ? WHERE user_jid = ?";
    private static final String SET_OFFLINE = "UPDATE users SET user_jabber_online = 0 WHERE user_jid = ?";
    private static final String SET_ALL_OFFLINE = "UPDATE users SET user_jabber_online = 0 WHERE user_jabber_online = 1";
    private String connectionString = JiveGlobals.getProperty((String)"jdbcProvider.connectionString");

    @Override
    public void setHistoryDays(int historyDays) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllOffline() {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(SET_ALL_OFFLINE);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Unable to clean up user status", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnline(Session session) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(UPDATE_USER_STATUS);
            pstmt.setString(1, session.getAddress().getNode());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Unable to update user status for " + session.getAddress(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffline(Session session, Date logoffDate) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(SET_OFFLINE);
            pstmt.setString(1, session.getAddress().getNode());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Unable to update user status for " + session.getAddress(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPresence(Session session, String presenceText) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(SET_PRESENCE);
            pstmt.setString(1, presenceText);
            pstmt.setString(2, session.getAddress().getNode());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Unable to update presence for " + session.getAddress(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    private Connection getConnection() throws SQLException {
        if (this.connectionString == null) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }

    @Override
    public void deleteOldHistoryEntries() {
    }
}

