/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.File;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginManagerListener;
import org.jivesoftware.openfire.plugin.InterpretedXMLPrinter;
import org.jivesoftware.openfire.plugin.RawPrintFilter;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.SystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerPlugin
implements Plugin {
    static final String PLUGIN_NAME = "XML Debugger Plugin";
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerPlugin.class);
    static final String PROPERTY_PREFIX = "plugin.xmldebugger.";
    private static DebuggerPlugin instance;
    private final RawPrintFilter defaultPortFilter;
    private final RawPrintFilter oldPortFilter;
    private final RawPrintFilter componentPortFilter;
    private final RawPrintFilter multiplexerPortFilter;
    private final InterpretedXMLPrinter interpretedPrinter;
    private boolean logWhitespace;
    private final SystemProperty<Boolean> logWhitespaceProperty = SystemProperty.Builder.ofType(Boolean.class).setKey("plugin.xmldebugger.logWhitespace").setDefaultValue((Object)Boolean.FALSE).setDynamic(true).setPlugin("XML Debugger Plugin").addListener(enabled -> {
        this.logWhitespace = enabled;
    }).build();
    private boolean loggingToStdOut;
    private final SystemProperty<Boolean> loggingToStdOutProperty = SystemProperty.Builder.ofType(Boolean.class).setKey("plugin.xmldebugger.logToStdOut").setDefaultValue((Object)Boolean.TRUE).setDynamic(true).setPlugin("XML Debugger Plugin").addListener(enabled -> {
        this.loggingToStdOut = enabled;
    }).build();
    private boolean loggingToFile;
    private final SystemProperty<Boolean> loggingToFileProperty = SystemProperty.Builder.ofType(Boolean.class).setKey("plugin.xmldebugger.logToFile").setDefaultValue((Object)Boolean.FALSE).setDynamic(true).setPlugin("XML Debugger Plugin").addListener(enabled -> {
        this.loggingToFile = enabled;
    }).build();

    public DebuggerPlugin() {
        this.loggingToStdOut = (Boolean)this.loggingToStdOutProperty.getValue();
        this.loggingToFile = (Boolean)this.loggingToFileProperty.getValue();
        this.logWhitespace = (Boolean)this.logWhitespaceProperty.getValue();
        this.defaultPortFilter = new RawPrintFilter(this, "C2S");
        this.oldPortFilter = new RawPrintFilter(this, "SSL");
        this.componentPortFilter = new RawPrintFilter(this, "ExComp");
        this.multiplexerPortFilter = new RawPrintFilter(this, "CM");
        this.interpretedPrinter = new InterpretedXMLPrinter(this);
        DebuggerPlugin.setInstance(this);
    }

    private static void setInstance(DebuggerPlugin instance) {
        DebuggerPlugin.instance = instance;
    }

    public static DebuggerPlugin getInstance() {
        return instance;
    }

    public void initializePlugin(final PluginManager pluginManager, File pluginDirectory) {
        pluginManager.addPluginManagerListener(new PluginManagerListener(){

            public void pluginsMonitored() {
                pluginManager.removePluginManagerListener((PluginManagerListener)this);
                DebuggerPlugin.this.addInterceptors();
            }
        });
    }

    private void addInterceptors() {
        ConnectionManagerImpl connManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        this.defaultPortFilter.addFilterToChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.SOCKET_C2S, false));
        this.oldPortFilter.addFilterToChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.SOCKET_C2S, true));
        this.componentPortFilter.addFilterToChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.COMPONENT, false));
        this.multiplexerPortFilter.addFilterToChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.CONNECTION_MANAGER, false));
        this.interpretedPrinter.setEnabled(this.interpretedPrinter.isEnabled());
        LOGGER.info("Plugin initialisation complete");
    }

    public void destroyPlugin() {
        ConnectionManagerImpl connManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        this.defaultPortFilter.removeFilterFromChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.SOCKET_C2S, false));
        this.oldPortFilter.removeFilterFromChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.SOCKET_C2S, true));
        this.componentPortFilter.removeFilterFromChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.COMPONENT, false));
        this.multiplexerPortFilter.removeFilterFromChain((SocketAcceptor)connManager.getSocketAcceptor(ConnectionType.CONNECTION_MANAGER, false));
        this.defaultPortFilter.shutdown();
        this.oldPortFilter.shutdown();
        this.componentPortFilter.shutdown();
        this.multiplexerPortFilter.shutdown();
        this.interpretedPrinter.shutdown();
        LOGGER.info("Plugin destruction complete");
    }

    public RawPrintFilter getDefaultPortFilter() {
        return this.defaultPortFilter;
    }

    public RawPrintFilter getOldPortFilter() {
        return this.oldPortFilter;
    }

    public RawPrintFilter getComponentPortFilter() {
        return this.componentPortFilter;
    }

    public RawPrintFilter getMultiplexerPortFilter() {
        return this.multiplexerPortFilter;
    }

    public InterpretedXMLPrinter getInterpretedPrinter() {
        return this.interpretedPrinter;
    }

    public boolean isLoggingToStdOut() {
        return this.loggingToStdOut;
    }

    public void setLoggingToStdOut(boolean enabled) {
        this.loggingToStdOutProperty.setValue((Object)enabled);
    }

    public boolean isLoggingToFile() {
        return this.loggingToFile;
    }

    public void setLoggingToFile(boolean enabled) {
        this.loggingToFileProperty.setValue((Object)enabled);
    }

    void log(String messageToLog) {
        if (this.loggingToStdOut) {
            System.out.println(messageToLog);
        }
        if (this.loggingToFile) {
            LOGGER.info(messageToLog);
        }
    }

    public void setLogWhitespace(boolean enabled) {
        this.logWhitespaceProperty.setValue((Object)enabled);
    }

    public boolean isLoggingWhitespace() {
        return this.logWhitespace;
    }
}

