/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.net.UnknownHostException;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.plugin.DebuggerPlugin;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.SystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class InterpretedXMLPrinter
implements PacketInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpretedXMLPrinter.class);
    private final SystemProperty<Boolean> enabledProperty = SystemProperty.Builder.ofType(Boolean.class).setKey("plugin.xmldebugger.interpretedAllowed").setDefaultValue((Object)Boolean.FALSE).setDynamic(true).setPlugin("XML Debugger Plugin").addListener(this::enabled).build();
    private final DebuggerPlugin plugin;
    private boolean enabled;

    InterpretedXMLPrinter(DebuggerPlugin plugin) {
        this.plugin = plugin;
    }

    public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) {
        if (session != null && !processed) {
            String hostAddress;
            try {
                hostAddress = "/" + session.getHostAddress() + ":?????";
            }
            catch (UnknownHostException ignored) {
                hostAddress = "";
            }
            this.plugin.log(String.format("INT %-16s - %s - (%11s): %s", hostAddress, incoming ? "RECV" : "SENT", session.getStreamID(), packet.toXML()));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabledProperty.setValue((Object)enabled);
    }

    private void enabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            LOGGER.info("Interpreted XML logger enabled");
            InterceptorManager.getInstance().addInterceptor((PacketInterceptor)this);
        } else {
            LOGGER.info("Interpreted XML logger disabled");
            this.shutdown();
        }
    }

    void shutdown() {
        InterceptorManager.getInstance().removeInterceptor((PacketInterceptor)this);
    }
}

