/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.jivesoftware.openfire.plugin.DebuggerPlugin;
import org.jivesoftware.util.SystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawPrintFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawPrintFilter.class);
    private static final String FILTER_NAME = "rawDebugger";
    private final DebuggerPlugin plugin;
    private final String prefix;
    private final Collection<IoSession> sessions = new ConcurrentLinkedQueue<IoSession>();
    private boolean enabled;
    private final SystemProperty<Boolean> enabledProperty;

    RawPrintFilter(DebuggerPlugin plugin, String prefix) {
        this.plugin = plugin;
        this.prefix = prefix;
        this.enabledProperty = SystemProperty.Builder.ofType(Boolean.class).setKey("plugin.xmldebugger." + prefix.toLowerCase()).setDefaultValue((Object)Boolean.TRUE).setDynamic(true).setPlugin("XML Debugger Plugin").addListener(this::enabled).build();
        this.enabled((Boolean)this.enabledProperty.getValue());
    }

    void addFilterToChain(SocketAcceptor acceptor) {
        if (acceptor == null) {
            LOGGER.debug("Not adding filter '{}' for {} to acceptor that is null.", (Object)FILTER_NAME, (Object)this.prefix);
            return;
        }
        DefaultIoFilterChainBuilder chain = acceptor.getFilterChain();
        if (chain.contains("compression")) {
            LOGGER.debug("Adding filter '{}' for {} as the first filter after the compression filter in acceptor {}", new Object[]{FILTER_NAME, this.prefix, acceptor});
            chain.addAfter("compression", FILTER_NAME, (IoFilter)this);
        } else if (chain.contains("tls")) {
            LOGGER.debug("Adding filter '{}' for {} as the first filter after the TLS filter in acceptor {}", new Object[]{FILTER_NAME, this.prefix, acceptor});
            chain.addAfter("tls", FILTER_NAME, (IoFilter)this);
        } else {
            LOGGER.debug("Adding filter '{}' for {} as the last filter in acceptor {}", new Object[]{FILTER_NAME, this.prefix, acceptor});
            chain.addLast(FILTER_NAME, (IoFilter)this);
        }
    }

    void removeFilterFromChain(SocketAcceptor acceptor) {
        if (acceptor == null) {
            LOGGER.debug("Not removing filter '{}' for {} from acceptor that is null.", (Object)FILTER_NAME, (Object)this.prefix);
            return;
        }
        if (acceptor.getFilterChain().contains(FILTER_NAME)) {
            LOGGER.debug("Removing filter '{}' for {} from acceptor {}", new Object[]{FILTER_NAME, this.prefix, acceptor});
            acceptor.getFilterChain().remove(FILTER_NAME);
        } else {
            LOGGER.debug("Unable to remove non-existing filter '{}' for {} from acceptor {}", new Object[]{FILTER_NAME, this.prefix, acceptor});
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (this.enabled && message instanceof String && (this.plugin.isLoggingWhitespace() || !((String)message).isEmpty())) {
            this.plugin.log(this.messagePrefix(session, "RECV") + ": " + message);
        }
        super.messageReceived(nextFilter, session, message);
    }

    private void logSentBuffer(IoSession session, IoBuffer ioBuffer) {
        int currentPos = ioBuffer.position();
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ioBuffer.buf());
        if (this.plugin.isLoggingWhitespace() || charBuffer.length() > 0) {
            this.plugin.log(this.messagePrefix(session, "SENT") + ": " + charBuffer);
        }
        ioBuffer.position(currentPos);
    }

    private String messagePrefix(IoSession session, String messageType) {
        String nowAsString = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        return String.format("%s - %s %-16s - %s - (%11s)", nowAsString, this.prefix, session.getRemoteAddress() == null ? "" : session.getRemoteAddress(), messageType, session.hashCode());
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (this.enabled && writeRequest.getOriginalMessage() instanceof IoBuffer) {
            this.logSentBuffer(session, (IoBuffer)writeRequest.getOriginalMessage());
        }
        super.messageSent(nextFilter, session, writeRequest);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabledProperty.setValue((Object)enabled);
    }

    private void enabled(boolean enabled) {
        this.enabled = enabled;
        LOGGER.info("{} logger {}", (Object)this.prefix, (Object)(enabled ? "enabled" : "disabled"));
    }

    void shutdown() {
        for (IoSession session : this.sessions) {
            session.getFilterChain().remove(FILTER_NAME);
        }
        this.sessions.clear();
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.sessions.add(session);
        if (this.enabled) {
            this.plugin.log(this.messagePrefix(session, "OPEN"));
        }
        super.sessionCreated(nextFilter, session);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.sessions.remove(session);
        if (this.enabled) {
            this.plugin.log(this.messagePrefix(session, "CLSD"));
        }
        super.sessionClosed(nextFilter, session);
    }
}

